/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.steps;

import filenet.vw.api.VWMapNode;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.steps.IVWPropertyTab;
import filenet.vw.toolkit.design.property.steps.VWBaseStepPropertiesPanel;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.uicontrols.tabbedPane.VWCustomTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;

public abstract class VWStepPropertyTabs
extends VWBaseStepPropertiesPanel {
    protected static final int TAB_GENERAL = 1;
    protected static final int TAB_PARAMETERS = 2;
    protected static final int TAB_ROUTING = 4;
    protected static final int TAB_ASSIGNMENTS = 8;
    protected static final int TAB_DEADLINE = 16;
    protected static final int TAB_RULES = 32;
    protected static final int TAB_ATTRIBUTES = 64;
    protected static final int TAB_SIMULATION = 128;
    protected static final int TAB_DESCRIPTION = 256;
    protected IVWPropertyTab m_generalTab = null;
    protected IVWPropertyTab m_parametersTab = null;
    protected IVWPropertyTab m_routingTab = null;
    protected IVWPropertyTab m_assignmentsTab = null;
    protected IVWPropertyTab m_deadlineTab = null;
    protected IVWPropertyTab m_rulesTab = null;
    protected IVWPropertyTab m_attributesTab = null;
    protected IVWPropertyTab m_simulationTab = null;
    protected IVWPropertyTab m_descriptionTab = null;
    protected VWCustomTabbedPane m_tabbedPane = null;

    public void init(VWAuthPropertyData authPropertyData, VWMapNode vwMapNode, int nTabsToAdd) {
        super.init(authPropertyData, vwMapNode);
        this.addPropertyTabs(nTabsToAdd);
        this.m_tabbedPane.setSelectedIndex(0);
    }

    public void setSelectedStep(VWMapNode vwMapNode) {
        if (vwMapNode == this.m_currentMapNode) {
            return;
        }
        if (this.m_generalTab != null) {
            this.m_generalTab.setSelectedStep(vwMapNode);
        }
        if (this.m_parametersTab != null) {
            this.m_parametersTab.setSelectedStep(vwMapNode);
        }
        if (this.m_routingTab != null) {
            this.m_routingTab.setSelectedStep(vwMapNode);
        }
        if (this.m_assignmentsTab != null) {
            this.m_assignmentsTab.setSelectedStep(vwMapNode);
        }
        if (this.m_deadlineTab != null) {
            this.m_deadlineTab.setSelectedStep(vwMapNode);
        }
        if (this.m_rulesTab != null) {
            this.m_rulesTab.setSelectedStep(vwMapNode);
        }
        if (this.m_attributesTab != null) {
            this.m_attributesTab.setSelectedStep(vwMapNode);
        }
        if (this.m_simulationTab != null) {
            this.m_simulationTab.setSelectedStep(vwMapNode);
        }
        if (this.m_descriptionTab != null) {
            this.m_descriptionTab.setSelectedStep(vwMapNode);
        }
    }

    public void displayHelpPage() {
        String tabTitle = this.m_tabbedPane.getTitleAt(this.m_tabbedPane.getSelectedIndex());
        if (VWStringUtils.compare(tabTitle, VWResource.s_mainTabStr) == 0) {
            this.displayHelpPage(1);
        } else if (VWStringUtils.compare(tabTitle, VWResource.s_parametersTabStr) == 0) {
            this.displayHelpPage(2);
        } else if (VWStringUtils.compare(tabTitle, VWResource.s_routingTabStr) == 0) {
            this.displayHelpPage(4);
        } else if (VWStringUtils.compare(tabTitle, VWResource.s_assignmentsTabStr) == 0) {
            this.displayHelpPage(8);
        } else if (VWStringUtils.compare(tabTitle, VWResource.s_deadlineTabStr) == 0) {
            this.displayHelpPage(16);
        } else if (VWStringUtils.compare(tabTitle, VWResource.s_rules) == 0) {
            this.displayHelpPage(32);
        } else if (VWStringUtils.compare(tabTitle, VWResource.s_attributes) == 0) {
            this.displayHelpPage(64);
        } else if (VWStringUtils.compare(tabTitle, VWResource.s_simulation) == 0) {
            this.displayHelpPage(128);
        } else if (VWStringUtils.compare(tabTitle, VWResource.s_descriptionStr) == 0) {
            this.displayHelpPage(256);
        }
    }

    public void releaseReferences() {
        if (this.m_generalTab != null) {
            this.m_generalTab.releaseReferences();
            this.m_generalTab = null;
        }
        if (this.m_parametersTab != null) {
            this.m_parametersTab.releaseReferences();
            this.m_parametersTab = null;
        }
        if (this.m_routingTab != null) {
            this.m_routingTab.releaseReferences();
            this.m_routingTab = null;
        }
        if (this.m_assignmentsTab != null) {
            this.m_assignmentsTab.releaseReferences();
            this.m_assignmentsTab = null;
        }
        if (this.m_deadlineTab != null) {
            this.m_deadlineTab.releaseReferences();
            this.m_deadlineTab = null;
        }
        if (this.m_rulesTab != null) {
            this.m_rulesTab.releaseReferences();
            this.m_rulesTab = null;
        }
        if (this.m_attributesTab != null) {
            this.m_attributesTab.releaseReferences();
            this.m_attributesTab = null;
        }
        if (this.m_simulationTab != null) {
            this.m_simulationTab.releaseReferences();
            this.m_simulationTab = null;
        }
        if (this.m_descriptionTab != null) {
            this.m_descriptionTab.releaseReferences();
            this.m_descriptionTab = null;
        }
        super.releaseReferences();
    }

    protected void initUIControls() {
        try {
            this.removeAll();
            this.setLayout(new BorderLayout());
            this.m_tabbedPane = new VWCustomTabbedPane(0);
            this.add((Component)this.m_tabbedPane, "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected abstract void displayHelpPage(int var1);

    protected void addTab(int nTabId) {
        try {
            switch (nTabId) {
                case 1: {
                    if (this.m_generalTab == null) break;
                    this.m_generalTab.init(this.m_authPropertyData, this.m_currentMapNode);
                    this.m_tabbedPane.addTab(VWResource.s_mainTabStr, (JPanel)((Object)this.m_generalTab));
                    break;
                }
                case 2: {
                    if (this.m_parametersTab == null) break;
                    this.m_parametersTab.init(this.m_authPropertyData, this.m_currentMapNode);
                    this.m_tabbedPane.addTab(VWResource.s_parametersTabStr, (JPanel)((Object)this.m_parametersTab));
                    break;
                }
                case 4: {
                    if (this.m_routingTab == null) break;
                    this.m_routingTab.init(this.m_authPropertyData, this.m_currentMapNode);
                    this.m_tabbedPane.addTab(VWResource.s_routingTabStr, (JPanel)((Object)this.m_routingTab));
                    break;
                }
                case 8: {
                    if (this.m_assignmentsTab == null) break;
                    this.m_assignmentsTab.init(this.m_authPropertyData, this.m_currentMapNode);
                    this.m_tabbedPane.addTab(VWResource.s_assignmentsTabStr, (JPanel)((Object)this.m_assignmentsTab));
                    break;
                }
                case 16: {
                    if (this.m_deadlineTab == null) break;
                    this.m_deadlineTab.init(this.m_authPropertyData, this.m_currentMapNode);
                    this.m_tabbedPane.addTab(VWResource.s_deadlineTabStr, (JPanel)((Object)this.m_deadlineTab));
                    break;
                }
                case 32: {
                    if (this.m_rulesTab == null) break;
                    this.m_rulesTab.init(this.m_authPropertyData, this.m_currentMapNode);
                    this.m_tabbedPane.addTab(VWResource.s_rules, (JPanel)((Object)this.m_rulesTab));
                    break;
                }
                case 64: {
                    if (this.m_attributesTab == null) break;
                    this.m_attributesTab.init(this.m_authPropertyData, this.m_currentMapNode);
                    this.m_tabbedPane.addTab(VWResource.s_attributes, (JPanel)((Object)this.m_attributesTab));
                    break;
                }
                case 128: {
                    if (this.m_simulationTab == null) break;
                    this.m_simulationTab.init(this.m_authPropertyData, this.m_currentMapNode);
                    this.m_tabbedPane.addTab(VWResource.s_simulation, (JPanel)((Object)this.m_simulationTab));
                    break;
                }
                case 256: {
                    if (this.m_descriptionTab == null) break;
                    this.m_descriptionTab.init(this.m_authPropertyData, this.m_currentMapNode);
                    this.m_tabbedPane.addTab(VWResource.s_descriptionStr, (JPanel)((Object)this.m_descriptionTab));
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void addPropertyTabs(int nTabs) {
        if ((nTabs & 1) != 0) {
            this.addTab(1);
        }
        if ((nTabs & 2) != 0) {
            this.addTab(2);
        }
        if ((nTabs & 4) != 0) {
            this.addTab(4);
        }
        if ((nTabs & 8) != 0) {
            this.addTab(8);
        }
        if ((nTabs & 0x10) != 0) {
            this.addTab(16);
        }
        if ((nTabs & 0x20) != 0) {
            this.addTab(32);
        }
        if ((nTabs & 0x40) != 0) {
            this.addTab(64);
        }
        if ((nTabs & 0x80) != 0) {
            this.addTab(128);
        }
        if ((nTabs & 0x100) != 0) {
            this.addTab(256);
        }
    }
}

